/****************************************************************************/
/* FILE NAME: eDMA_eQADC_setup.c               COPYRIGHT (c) Freescale 2006	*/
/*                                                All Rights Reserved     	*/
/* DESCRIPTION:                                                           	*/
/* This file contains the necessary setup code for configuring the eDMA	  	*/
/* and eQADC.						          							  	*/
/*==========================================================================*/
/* REV      AUTHOR       DATE       DESCRIPTION OF CHANGE                 	*/
/* ---   -----------   ----------   ---------------------                 	*/
/* 0.1   D.Paterson     01/Feb/07     Initial version                     	*/
/****************************************************************************/
#include "mpc5561.h"
#include "eQADC_common.h"
#include "vars.h"
#include "typedefs.h"

void mpc5554_dma_int_fcn();
void Check_eQADC_End();
void eqadc_init_fcn();
void mpc5554_dma_config();


/*************************************************************************
*	Function Name: 	Setup_eQADC											 *
*	Description: 	This sets up the eQADC to scan 2 channels and	 	 *
*					place the results in RQUEUE0/1. The eQADC is  		 *
*					set for software triggered continuous scan mode.	 *
*					This also calls functions for setting up the eDMA.	 *
*	Called By :		setup_functions										 *
**************************************************************************/ 
void Setup_eQADC(void)
{
	int i;
		
	mpc5554_dma_int_fcn();
	eqadc_init_fcn();
	
	mpc5554_dma_config();
	
	CQUEUE0  = 0x01010100;  								// Result to RFIFO, ADC0, AN9, calibrate results, Right justified signed.
	CQUEUE1  = 0x02110200;  								// Result to RFIF1, ADC1, AN10, calibrate results, Right justified signed.
	
 	EQADC.CFCR[0].B.MODE = SW_TRIG_CS;						// Continuous Scan - Software Triggered
 	EQADC.CFCR[1].B.MODE = SW_TRIG_CS;						// Continuous Scan - Software Triggered
 	
 	EDMA.CERQR.R = 0x1;										// Disable eDMA to RQUEUE0
 	EDMA.CERQR.R = 0x3;										// Disable eDMA to RQUEUE1
 	
 	EQADC.IDCR[0].R = 0x0303;								// Enable DMA transfers for CQ0 and RQ0
	EQADC.IDCR[1].R = 0x0303;								// Enable DMA transfers for CQ1 and RQ1
}

/*************************************************************************
*	Function Name: 	Check_eQADC_End										 *
*	Description: 	This function checks that the eQADC has completed	 *
*	Called By :		Setup_eQADC											 *
**************************************************************************/ 
void Check_eQADC_End()
{
	// Wait for DONE bit to be set indication end of conversions
	while (EDMA.TCD[1].DONE == 0)
    {};
    while (EDMA.TCD[3].DONE == 0)
    {};
}

/*************************************************************************
*	Function Name: 	create_ADC_config									 *
*	Description: 	This function sets up CCWs for ADC0/1 configuration	 *
*	Called By :		eqadc_init_fcn										 *
**************************************************************************/ 
void create_ADC_config()
{
   /* Configuration Command words */
   CQUEUE5[0] = 0x02000602;  /* ADC1 ADC_TSCR Time stamp control */
   CQUEUE5[1] = 0x02000003;  /* ADC1 ADC_TBCR Time base counter 0x0000=reset */
   CQUEUE5[2] = 0x02800A01;  /* ADC1 ADC_CR Control register */
   CQUEUE5[3] = 0x00000602;  /* ADC0 ADC_TSCR Time stamp control */
   CQUEUE5[4] = 0x00000003;  /* ADC0 ADC_TBCR Time base counter 0x0000=reset */
   CQUEUE5[5] = 0x80800A01;  /* ADC0 ADC_CR Control register */
}
             
/*************************************************************************
*	Function Name: 	eqadc_init_fcn									 	 *
*	Description: 	This function sets up the eQADC for ADC0/1 setup	 *
*	Called By :		Setup_eQADC										     *
**************************************************************************/ 
void eqadc_init_fcn(void)
{

   create_ADC_config();

   /* EQADC Module Configuration Register (EQADC_MCR) */                               
   EQADC.MCR.R   = 0x00000000;   // EQADC SSI is Disabled                     
                                 // Debug Mode Disabled                       

   /* EQADC NULL Message Send Format Register (EQADC_NMSFR) */                
   EQADC.NMSFR.R = 0x0000000;   // Null Message Format              

   /* EQADC External Trigger Digital Filter Register (EQADC_ETDFR)*/ 
   EQADC.ETDFR.R  = 0x00000000; // Digital Filter Length = 2*(sys clock period)    

   /* Use Queue 5 to initialise ADC registers */
   /* EQADC CFIFO Control Register 0 (EQADC_CFCR0)  CFIFO-0 */                 
   EQADC.CFCR[5].B.MODE = SW_TRIG_SS;         // Trigger - Software Triggered 

   /* EQADC Interrupt and DMA Control Registers (EQADC_IDCR) IDCR0 */          
   EQADC.IDCR[5].R = 0x0300;      // NonCoherency Interrupt is : Disabled (0)
                                  // Trigger Overrun Interrupt is :Disabled (0)
                                  // Pause Interrupt is : Disabled (0)
                                  // End Of Queue Interrupt is : Disabled (0)
                                  // CFIFO Underflow Interrupt is : Disabled (0)
                                  // CFIFO Fill Enable is : Enabled (1)
                                  // CFIFO Fill Select : Enabled (1)
                                  // RFIFO Overflow Interrupt is : Disabled (0)
                                  // RFIFO Drain is : Disabled (0)
                                  // RFIFO Drain Select is : Disabled (0)

   EQADC.CFCR[5].B.SSE = 0x1;    // Single Scan Enable Bit - 1   
    
   while(EQADC.CFSR.B.CFS5 != WAIT){};  // Wait for queue to go to IDLE before setting mode to user setting.

   /* EQADC CFIFO Control Register 0 (EQADC_CFCR0)  CFIFO-0 */               
   EQADC.CFCR[5].B.MODE = DISABLE_Q;         // Trigger - Software Triggered 
   EQADC.IDCR[5].R = 0x0000;
   EQADC.FISR[5].B.EOQF = 0x1;
   EQADC.CFCR[5].B.CFINV = 1;

}

/*************************************************************************
*	Function Name: 	mpc5554_dma_int_fcn									 *
*	Description: 	This function sets up the eDMA for ADC0/1 setup	     *
*	Called By :		Setup_eQADC										     *
**************************************************************************/ 
void mpc5554_dma_int_fcn(void)
{
		// DMA Configuration Register (DMACR)                     
     	EDMA.CR.R   = 0x00000400;  // Channel group 1 priority. Group 1 priority level when fixed priority group arbitration is enabled.   // Group Arbitration scheme is : Fixed Priority 
     
		// DMA Enable Request Registers (DMAERQL)                     
     	EDMA.ERQRL.R   = 0x0000040C;  // DMA Enable Rquest Register Low (Channels 31-0) : 

		// DMA Enable Error Interrupt Request Registers (DMAEEIH,DMAEEIL)                     
     	EDMA.EEIRL.R   = 0x00000000;  // DMA Error Interrupt Enable Register Low (Channels 0-31) : 

		// DMA Channel Priority Register Settings (DCHPRIn) Channels 0 - 63                     
        EDMA.CPR[0].R = 0x00;    // Channel 0 is Priority 1, Channel Preemption is Disabled
        EDMA.CPR[1].R = 0x01;    // Channel 1 is Priority 2, Channel Preemption is Disabled
        EDMA.CPR[2].R = 0x02;    // Channel 2 is Priority 3, Channel Preemption is Disabled
        EDMA.CPR[3].R = 0x03;    // Channel 3 is Priority 4, Channel Preemption is Disabled
        EDMA.CPR[4].R = 0x04;    // Channel 4 is Priority 5, Channel Preemption is Disabled
        EDMA.CPR[5].R = 0x05;    // Channel 5 is Priority 6, Channel Preemption is Disabled
        EDMA.CPR[6].R = 0x06;    // Channel 6 is Priority 7, Channel Preemption is Disabled
        EDMA.CPR[7].R = 0x07;    // Channel 7 is Priority 8, Channel Preemption is Disabled
        EDMA.CPR[8].R = 0x08;    // Channel 8 is Priority 9, Channel Preemption is Disabled
        EDMA.CPR[9].R = 0x09;    // Channel 9 is Priority 10, Channel Preemption is Disabled
        EDMA.CPR[10].R = 0x0A;    // Channel 10 is Priority 11, Channel Preemption is Disabled
        EDMA.CPR[11].R = 0x0B;    // Channel 11 is Priority 12, Channel Preemption is Disabled
        EDMA.CPR[12].R = 0x0C;    // Channel 12 is Priority 13, Channel Preemption is Disabled
        EDMA.CPR[13].R = 0x0D;    // Channel 13 is Priority 14, Channel Preemption is Disabled
        EDMA.CPR[14].R = 0x0E;    // Channel 14 is Priority 15, Channel Preemption is Disabled
        EDMA.CPR[15].R = 0x0F;    // Channel 15 is Priority 16, Channel Preemption is Disabled
        EDMA.CPR[16].R = 0x00;    // Channel 16 is Priority 1, Channel Preemption is Disabled
        EDMA.CPR[17].R = 0x01;    // Channel 17 is Priority 2, Channel Preemption is Disabled
        EDMA.CPR[18].R = 0x02;    // Channel 18 is Priority 3, Channel Preemption is Disabled
        EDMA.CPR[19].R = 0x03;    // Channel 19 is Priority 4, Channel Preemption is Disabled
        EDMA.CPR[20].R = 0x04;    // Channel 20 is Priority 5, Channel Preemption is Disabled
        EDMA.CPR[21].R = 0x05;    // Channel 21 is Priority 6, Channel Preemption is Disabled
        EDMA.CPR[22].R = 0x06;    // Channel 22 is Priority 7, Channel Preemption is Disabled
        EDMA.CPR[23].R = 0x07;    // Channel 23 is Priority 8, Channel Preemption is Disabled
        EDMA.CPR[24].R = 0x08;    // Channel 24 is Priority 9, Channel Preemption is Disabled
        EDMA.CPR[25].R = 0x09;    // Channel 25 is Priority 10, Channel Preemption is Disabled
        EDMA.CPR[26].R = 0x0A;    // Channel 26 is Priority 11, Channel Preemption is Disabled
        EDMA.CPR[27].R = 0x0B;    // Channel 27 is Priority 12, Channel Preemption is Disabled
        EDMA.CPR[28].R = 0x0C;    // Channel 28 is Priority 13, Channel Preemption is Disabled
        EDMA.CPR[29].R = 0x0C;    // Channel 29 is Priority 13, Channel Preemption is Disabled
        EDMA.CPR[30].R = 0x0E;    // Channel 30 is Priority 15, Channel Preemption is Disabled
        EDMA.CPR[31].R = 0x0F;    // Channel 31 is Priority 16, Channel Preemption is Disabled

		// TCD 10 used to transfer configuration commands to CFIFO 5
		// Transfer Control Descriptor for CFIFO 05 - CH10
		EDMA.TCD[10].SADDR = (vuint32_t) &CQUEUE5;      //  Start Address 
		EDMA.TCD[10].DADDR = CFIFO5_PUSH;         		//  Destination address 
		EDMA.TCD[10].SMOD = 0x00;                 		//  Source address modulo 
		EDMA.TCD[10].DMOD = 0x00;                 		//  Destination address modulo 
		EDMA.TCD[10].DSIZE = 0x02;                		//  Destination transfer size : 32 Bits 
		EDMA.TCD[10].SSIZE = 0x02;                		//  Source transfer size : 32 Bits 
		EDMA.TCD[10].SOFF = 0x4;                  		//  Signed source address offset 
		EDMA.TCD[10].NBYTES = 0x00000004;         		//  Inner "minor" byte count 
		EDMA.TCD[10].SLAST = 0xFFFFFFE8;          		//  last Signed source address adjust 
		EDMA.TCD[10].DOFF = 0x0;                  		//  Signed destination address offset 
		EDMA.TCD[10].DLAST_SGA = 0x0;             		//  Signed destination address adjust 
		EDMA.TCD[10].BITER = 0x6;                 		//  begining "major" iteration count 
		EDMA.TCD[10].BITERE_LINK=0x0;             		
		EDMA.TCD[10].CITER=0x6;                   		//  Current "major" iteration count
		EDMA.TCD[10].CITERE_LINK=0;               		
		EDMA.TCD[10].BWC = 0x00;                  		//  Bandwidth control :  No DMA Stalls 
		EDMA.TCD[10].MAJORLINKCH = 0x00;          		//  Major Channel number 
		EDMA.TCD[10].MAJORE_LINK = 0x0;           		//  Major Channel Link : Disabled
		EDMA.TCD[10].DONE = 0x00;                 		//  Channel Done 
		EDMA.TCD[10].ACTIVE = 0x00;               		//  Channel ACtive
		EDMA.TCD[10].E_SG = 0x0;                  		//  Enable Scatter/Gather : Disabled
		EDMA.TCD[10].D_REQ = 0x1;                 		//  Disable TCD When done  
		EDMA.TCD[10].INT_HALF = 0x0;              		//  Interrupt on minor loop count : Disabled
		EDMA.TCD[10].INT_MAJ = 0x0;               		//  Interrupt on major loop completion : Disabled
		EDMA.TCD[10].START = 0x00;                		//  Explicit Channel Start bit
}

/*************************************************************************
*	Function Name: 	mpc5554_dma_config									 *
*	Description: 	This function sets up the eDMA CQUEUE0/1 & RQUEUE0/1 *
*					push and pull.										 *
*	Called By :		Setup_eQADC										     *
**************************************************************************/ 
void mpc5554_dma_config(void)
{
   		// DMA Enable Request Registers (DMAERQL)                     
   		EDMA.ERQRL.R   = 0x0000000F;  // DMA Enable Request Register Low (Channels 31-0) : 
   		
   		// DMA Enable Error Interrupt Request Registers (DMAEEIL)                     
   		EDMA.EEIRL.R   = 0x00000000;  // DMA Error Interrupt Enable Register Low (Channels 0-31) : 
   		
   		//  Transfer Control Descriptors for the EQADC DMA Interface.    
   		//  Transfer Control Descriptor for CFIFO 00 - CH0
   		EDMA.TCD[0].SADDR = (vuint32_t) &CQUEUE0;       //  Start Address 
   		EDMA.TCD[0].DADDR = CFIFO0_PUSH;         		//  Destination address 
   		EDMA.TCD[0].SMOD = 0x00;                 		//  Source address modulo 
   		EDMA.TCD[0].DMOD = 0x00;                 		//  Destination address modulo 
   		EDMA.TCD[0].DSIZE = 0x02;                		//  Destination transfer size : 32 Bits 
   		EDMA.TCD[0].SSIZE = 0x02;                		//  Source transfer size : 32 Bits 
   		EDMA.TCD[0].SOFF = 0x4;                  		//  Signed source address offset 
   		EDMA.TCD[0].NBYTES = 0x00000004;         		//  Inner "minor" byte count 
   		EDMA.TCD[0].SLAST = -0x4;               			//  last Signed source address adjust 
   		EDMA.TCD[0].CITERE_LINK=0;
   		EDMA.TCD[0].CITER=0x1;                   		//  Current "major" iteration count 
   		EDMA.TCD[0].DOFF = 0x0;                  		//  Signed destination address offset 
   		EDMA.TCD[0].DLAST_SGA = 0x0;             		//  Signed destination address adjust 
   		EDMA.TCD[0].BITERE_LINK=0x0;
   		EDMA.TCD[0].BITER = 0x1;                 		//  begining "major" iteration count 
   		EDMA.TCD[0].BWC = 0x00;                  		//  Bandwidth control :  No DMA Stalls 
   		EDMA.TCD[0].MAJORLINKCH = 0x00;          		//  Major Channel number 
   		EDMA.TCD[0].MAJORE_LINK = 0x0;           		//  Major Channel Link : Disabled
   		EDMA.TCD[0].DONE = 0x00;                 		//  Channel Done 
   		EDMA.TCD[0].ACTIVE = 0x00;               		//  Channel ACtive
   		EDMA.TCD[0].E_SG = 0x0;                  		//  Enable Scatter/Gather : Disabled
   		EDMA.TCD[0].D_REQ = 0x0;                 		//  DO NOT Disable TCD When done  
   		EDMA.TCD[0].INT_HALF = 0x0;              		//  Interrupt on minor loop count : Disabled
   		EDMA.TCD[0].INT_MAJ = 0x0;               		//  Interrupt on major loop completion : Disabled
   		EDMA.TCD[0].START = 0x00;                		//  Explicit Channel Start bit
   		
		//  Transfer Control Descriptor for RFIFO 00 - CH1
   		EDMA.TCD[1].SADDR = RFIFO0_POP;          		//  Start Address 
   		EDMA.TCD[1].DADDR = (vuint32_t) &RQUEUE0;       //  Destination address 
   		EDMA.TCD[1].SMOD = 0x00;                 		//  Source address modulo 
   		EDMA.TCD[1].DMOD = 0x00;                 		//  Destination address modulo 
   		EDMA.TCD[1].DSIZE = 0x01;                		//  Destination transfer size : 16 Bits 
   		EDMA.TCD[1].SSIZE = 0x01;                		//  Source transfer size : 16 Bits 
   		EDMA.TCD[1].SOFF = 0x0;                  		//  Signed source address offset 
   		EDMA.TCD[1].NBYTES = 0x0000002;         		//  Inner "minor" byte count 
   		EDMA.TCD[1].SLAST = 0x0;                 		//  Last Signed source address adjust
   		EDMA.TCD[1].DOFF = 0x2;                  		//  Signed destination address offset 
   		EDMA.TCD[1].DLAST_SGA = -0x800;     			//  Signed destination address adjust
   		EDMA.TCD[1].BITERE_LINK=0x0;
   		EDMA.TCD[1].BITER = 0x400;              		//  begining "major" iteration count 
   		EDMA.TCD[1].CITERE_LINK=0;
   		EDMA.TCD[1].CITER=0x400;                		//  Current "major" iteration count 
   		EDMA.TCD[1].BWC = 0x00;                  		//  Bandwidth control :  No DMA Stalls 
   		EDMA.TCD[1].MAJORLINKCH = 0x00;          		//  Major Channel number 
   		EDMA.TCD[1].MAJORE_LINK = 0x0;            		//  Major Channel Link : Disabled
   		EDMA.TCD[1].DONE = 0x00;                 		//  Channel Done 
   		EDMA.TCD[1].ACTIVE = 0x00;               		//  Channel ACtive
   		EDMA.TCD[1].E_SG = 0x0;                   		//  Enable Scatter/Gather : Disabled
   		EDMA.TCD[1].D_REQ = 0x1;                  		//  Do Disable TCD When done  
   		EDMA.TCD[1].INT_HALF = 0x0;               		//  Interrupt on minor loop count : Disabled
   		EDMA.TCD[1].INT_MAJ = 0x0;                		//  Interrupt on major loop completion : Disabled
   		EDMA.TCD[1].START = 0x00;                		//  Explicit Channel Start bit
   		    
   		//  Transfer Control Descriptor for CFIF0 01 - CH2
   		EDMA.TCD[2].SADDR = (vuint32_t) &CQUEUE1;       //  Start Address 
   		EDMA.TCD[2].DADDR = CFIFO1_PUSH;         		//  Destination address 
   		EDMA.TCD[2].SMOD = 0x00;                 		//  Source address modulo 
   		EDMA.TCD[2].DMOD = 0x00;                 		//  Destination address modulo 
   		EDMA.TCD[2].DSIZE = 0x02;                		//  Destination transfer size : 32 Bits 
   		EDMA.TCD[2].SSIZE = 0x02;                		//  Source transfer size : 32 Bits 
   		EDMA.TCD[2].SOFF = 0x4;                  		//  Signed source address offset 
   		EDMA.TCD[2].NBYTES = 0x00000004;         		//  Inner "minor" byte count 
   		EDMA.TCD[2].SLAST = -0x4;                		//  last Signed source address adjust 
   		EDMA.TCD[2].CITERE_LINK=0;               		
   		EDMA.TCD[2].CITER=0x1;                   		//  Current "major" iteration count 
   		EDMA.TCD[2].DOFF = 0x0;                  		//  Signed destination address offset 
   		EDMA.TCD[2].DLAST_SGA = 0x0;             		//  Signed destination address adjust 
   		EDMA.TCD[2].BITERE_LINK=0x0;             		
   		EDMA.TCD[2].BITER = 0x1;                 		//  begining "major" iteration count 
   		EDMA.TCD[2].BWC = 0x00;                  		//  Bandwidth control :  No DMA Stalls 
   		EDMA.TCD[2].MAJORLINKCH = 0x00;          		//  Major Channel number 
   		EDMA.TCD[2].MAJORE_LINK = 0x0;           		//  Major Channel Link : Disabled
   		EDMA.TCD[2].DONE = 0x00;                 		//  Channel Done 
   		EDMA.TCD[2].ACTIVE = 0x00;               		//  Channel ACtive
   		EDMA.TCD[2].E_SG = 0x0;                  		//  Enable Scatter/Gather : Disabled
   		EDMA.TCD[2].D_REQ = 0x0;                 		//  DO NOT Disable TCD When done  
   		EDMA.TCD[2].INT_HALF = 0x0;              		//  Interrupt on minor loop count : Disabled
   		EDMA.TCD[2].INT_MAJ = 0x0;               		//  Interrupt on major loop completion : Disabled
   		EDMA.TCD[2].START = 0x00;                		//  Explicit Channel Start bit
   		
		//  Transfer Control Descriptor for RFIFO 01 - CH3
   		EDMA.TCD[3].SADDR = RFIFO1_POP;          		//  Start Address 
   		EDMA.TCD[3].DADDR = (vuint32_t) &RQUEUE1;       //  Destination address 
   		EDMA.TCD[3].SMOD = 0x00;                 		//  Source address modulo 
   		EDMA.TCD[3].DMOD = 0x00;                 		//  Destination address modulo 
   		EDMA.TCD[3].DSIZE = 0x01;                		//  Destination transfer size : 16 Bits 
   		EDMA.TCD[3].SSIZE = 0x01;                		//  Source transfer size : 16 Bits 
   		EDMA.TCD[3].SOFF = 0x0;                  		//  Signed source address offset 
   		EDMA.TCD[3].NBYTES = 0x0000002;         		//  Inner "minor" byte count 
   		EDMA.TCD[3].SLAST = 0x0;                 		//  Last Signed source address adjust
   		EDMA.TCD[3].DOFF = 0x2;                  		//  Signed destination address offset 
   		EDMA.TCD[3].DLAST_SGA = -0x800;     			//  Signed destination address adjust
   		EDMA.TCD[3].BITERE_LINK=0x0;
   		EDMA.TCD[3].BITER = 0x400;              		//  begining "major" iteration count 
   		EDMA.TCD[3].CITERE_LINK=0;
   		EDMA.TCD[3].CITER=0x400;                		//  Current "major" iteration count 
   		EDMA.TCD[3].BWC = 0x00;                  		//  Bandwidth control :  No DMA Stalls 
   		EDMA.TCD[3].MAJORLINKCH = 0x00;          		//  Major Channel number 
   		EDMA.TCD[3].MAJORE_LINK = 0x0;           		//  Major Channel Link : Disabled
   		EDMA.TCD[3].DONE = 0x00;                 		//  Channel Done 
   		EDMA.TCD[3].ACTIVE = 0x00;               		//  Channel ACtive
   		EDMA.TCD[3].E_SG = 0x0;                  		//  Enable Scatter/Gather : Disabled
   		EDMA.TCD[3].D_REQ = 0x1;                 		//  Do Disable TCD When done  
   		EDMA.TCD[3].INT_HALF = 0x0;              		//  Interrupt on minor loop count : Disabled
   		EDMA.TCD[3].INT_MAJ = 0x1;               		//  Interrupt on major loop completion : Enabled
   		EDMA.TCD[3].START = 0x00;                		//  Explicit Channel Start bit
}